%------------------------------------------------------------------------------
% File     : SYO520^1 : TPTP v7.4.0. Released v4.1.0.
% Domain   : Syntactic
% Problem  : A simple problem with a choice operator
% Version  : Especial.
% English  : 

% Refs     : [Bro10] Brown E. (2010), Email to Geoff Sutcliffe
% Source   : [Bro10]
% Names    : 

% Status   : Unsatisfiable
% Rating   : 0.00 v4.1.0
% Syntax   : Number of formulae    :    5 (   0 unit;   2 type;   0 defn)
%            Number of atoms       :   12 (   0 equality;   5 variable)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :   11 (   2   ~;   0   |;   0   &;   8   @)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    4 (   4   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    4 (   2   :;   0   =)
%            Number of variables   :    3 (   0 sgn;   1   !;   1   ?;   1   ^)
%                                         (   3   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_UNS_NEQ_NAR

% Comments : The operator eps for type i is given, and assumed to be a choice 
%            operator. This is to get around using the choice operator @+ in 
%            TH0 syntax (since it is not ). eps maybe semantically 
%            different from the choice operator @+ but a theorem prover may 
%            recognize eps is a choice operator and treat it accordingly.
%------------------------------------------------------------------------------
thf(eps,type,(
    eps: ( $i > $o ) > $i )).

thf(epschoice,axiom,(
    ! [P: $i > $o] :
      ( ? [X: $i] :
          ( P @ X )
     => ( P @ ( eps @ P ) ) ) )).

thf(p,type,(
    p: $i > $o )).

thf(ax1,axiom,
    ( p
    @ ( eps
      @ ^ [X: $i] :
          ~ ( p @ X ) ) )).

thf(ax2,axiom,(
    ~ ( p @ ( eps @ p ) ) )).

%------------------------------------------------------------------------------
